
// AACEncoderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AACEncoder.h"
#include "AACEncoderDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BYTE * g_p_audio_frame_buffer_background = NULL;

ULONG  g_n_audio_frame_length_background = 0;

ULONGLONG g_n_src_audio_sample_time = 0;

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEBUG] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

DWORD WINAPI on_push_audio_framebuffer( LPVOID params )
{
	CAACEncoderDlg *  pMainDialog = (CAACEncoderDlg *)(params);

	while ( TRUE && pMainDialog->m_bSetBuffer )
    {
		DWORD dwWaitResult = 0x00000000;

		dwWaitResult = WaitForSingleObject( pMainDialog->m_hAudioThreadBufferReadyEvent, INFINITE );		

		if( dwWaitResult == WAIT_OBJECT_0 )
		{
			if ( g_p_audio_frame_buffer_background != NULL && g_n_audio_frame_length_background > 0 )
			{
				if ( pMainDialog->m_nFileRendererRecordState == 0x00000001 )
				{
					ULONGLONG n_dst_sample_time = 0;

					BYTE * pStreamBuffer = NULL;

					ULONG  nStreamBufferSize = 0;

					AMESDK_CODEC_ENCODE( pMainDialog->m_hAudioAACEncoderDev, g_p_audio_frame_buffer_background, g_n_audio_frame_length_background, &pStreamBuffer, &nStreamBufferSize, g_n_src_audio_sample_time, &n_dst_sample_time );

					if ( pStreamBuffer != NULL && nStreamBufferSize > 0 )
					{
						if ( pMainDialog->m_pBinFile != NULL )
						{
							pMainDialog->m_pBinFile->Write( pStreamBuffer, nStreamBufferSize );
						}

						if ( pMainDialog->m_pTxtFile != NULL )
						{
							CString strTxt;

							strTxt.Format( "%d,%I64d\n", nStreamBufferSize, n_dst_sample_time );

							pMainDialog->m_pTxtFile->WriteString( strTxt );
						}
					}
				}
			}
		}
	}

	return 0;
}

BOOL on_process_preview_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CAACEncoderDlg *  pMainDialog = (CAACEncoderDlg *)(pUserData);	

	return TRUE;
}

BOOL on_process_audio_buffer_ex( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CAACEncoderDlg *  pMainDialog = (CAACEncoderDlg *)(pUserData);	

	if ( pBuffer != NULL && nBufferLen > 0 )
	{
		g_p_audio_frame_buffer_background = pBuffer;

		g_n_audio_frame_length_background = nBufferLen;		

		g_n_src_audio_sample_time = (ULONGLONG)(dSampleTime * 10000000);

		if(  pMainDialog->m_hAudioThreadBufferReadyEvent )
		{
			SetEvent( pMainDialog->m_hAudioThreadBufferReadyEvent );
		}		
	}

	return TRUE;
}

BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	BOOL returns = on_process_audio_buffer_ex( dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData );

	return returns;
}

// CAACEncoderDlg dialog


CAACEncoderDlg::CAACEncoderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CAACEncoderDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev = 0xFFFFFFFF;	

	m_hAudioDev = 0xFFFFFFFF;		
	
	m_hAudioAACEncoderDev = 0xFFFFFFFF;

	m_nFileRendererRecordState = 0x00000000;

	m_hAudioThreadBufferReadyEvent = NULL;

	m_hAudioThread = NULL;	

	m_hAudioThreadNumber = 0;

	m_bSetBuffer = FALSE;

	m_pTxtFile = NULL;

	m_pBinFile = NULL;
}

void CAACEncoderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAACEncoderDlg)
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	//}}AFX_DATA_MAP	
}

BEGIN_MESSAGE_MAP(CAACEncoderDlg, CDialogEx)
	//{{AFX_MSG_MAP(CAACEncoderDlg)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_START, &CAACEncoderDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CAACEncoderDlg::OnBnClickedBtnStop)
END_MESSAGE_MAP()


// CAACEncoderDlg message handlers

BOOL CAACEncoderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	CenterWindow();

	CString strCaption;

	strCaption.Format( "Yuan's %s Demo Software - AAC Encoder", PRODUCT_NAME );

	SetWindowText( strCaption );

	InitializeCriticalSection( &m_hAccessFileCriticalSection );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAACEncoderDlg::OnDestroy() 
{
	OnBnClickedBtnStop();

	HwUnInitialize();

	DeleteCriticalSection( &m_hAccessFileCriticalSection );

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CAACEncoderDlg::HwInitialize()
{
	PF_BUFFER_CALLBACK pfVideoPreviewBC = NULL;

	pfVideoPreviewBC = on_process_preview_video_buffer;

	PF_BUFFER_CALLBACK pfAudioPreviewBC = NULL;

	pfAudioPreviewBC = on_process_audio_buffer;

	CWnd *pPreviewWnd = GetDlgItem( IDC_STATIC_WINDOW );

	m_hVideoDev = AMESDK_CREATE_EX( CHIP_NAME, 2, 0,  pPreviewWnd->GetSafeHwnd(), pfVideoPreviewBC, FALSE, TRUE, TRUE, this );			

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		m_hVideoDev = 0xFFFFFFFF; 

		return FALSE; 		
	}

	m_hAudioDev = AMESDK_CREATE(  AUDIO_CHIP_NAME, 2, 0, pPreviewWnd->GetSafeHwnd(), pfAudioPreviewBC, this ); 

	// SETUP LIVE PATH PROPERTIES
	// 		
	AMESDK_SET_STANDARD( m_hVideoDev, NTSC );
	
	AMESDK_SET_FORMAT( m_hVideoDev, PREVIEW_COLORSPACE, WIDTH, HEIGHT, PREVIEW_BIT_COUNT, FPS );

	AMESDK_SET_INPUT( m_hVideoDev, SDI_INPUT );	

	m_hAudioAACEncoderDev = AMESDK_CREATE( "Common Analog Encoder (AAC)", 0, 7, NULL, NULL, NULL ); 

	if( m_hAudioAACEncoderDev & 0x80000000 ) 
	{ 
		m_hAudioAACEncoderDev = 0xFFFFFFFF; 

		return FALSE; 		
	}

	// SETUP AUDIO PATH (AAC) PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hAudioAACEncoderDev, 2, 16, 48000 );
	
	// SETUP AUDIO PATH (PCM) PROPERTIES
	//		
	AMESDK_SET_FORMAT( m_hAudioDev, 2, 16, 48000 );	

	AMESDK_SET_VOLUME( m_hAudioDev, 100 );

	AMESDK_RUN( m_hVideoDev );

	AMESDK_RUN( m_hAudioDev );

	AMESDK_RUN( m_hAudioAACEncoderDev );

	m_hAudioThreadBufferReadyEvent = CreateEvent( NULL, FALSE, FALSE, NULL );		

	m_bSetBuffer = TRUE;

	m_hAudioThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_push_audio_framebuffer ), (LPVOID)(this), 0, &m_hAudioThreadNumber );	

	return TRUE;
}

BOOL CAACEncoderDlg::HwUnInitialize()
{
	m_bSetBuffer = FALSE;

	Sleep( 100 );

	if ( m_hAudioThreadBufferReadyEvent )
	{
		ResetEvent( m_hAudioThreadBufferReadyEvent );

		CloseHandle( m_hAudioThreadBufferReadyEvent );	

		m_hAudioThreadBufferReadyEvent = NULL;
	}

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_STOP( m_hVideoDev );

		AMESDK_DESTROY( m_hVideoDev );
		
		m_hVideoDev = 0xFFFFFFFF; 
	}

	if( m_hAudioDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_STOP( m_hAudioDev );

		AMESDK_DESTROY( m_hAudioDev );
		
		m_hAudioDev = 0xFFFFFFFF; 
	}

	if( m_hAudioAACEncoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hAudioAACEncoderDev );
		
		m_hAudioAACEncoderDev = 0xFFFFFFFF; 
	}		

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAACEncoderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAACEncoderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CAACEncoderDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CAACEncoderDlg::OnBnClickedBtnStart()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( FALSE );

	m_btnStop.EnableWindow( TRUE );

	m_pTxtFile = NULL;

	m_pBinFile = NULL;

	CHAR pszTxtFile[ MAX_PATH ];

	CHAR pszBinFile[ MAX_PATH ];

	sprintf( pszTxtFile, "%sAAC_%d_%d_%.2f.TXT", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	sprintf( pszBinFile, "%sAAC_%d_%d_%.2f.AAC", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	m_pTxtFile = new CStdioFile( pszTxtFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText );	

	m_pBinFile = new CStdioFile( pszBinFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeBinary );

	m_nFileRendererRecordState = 0x00000001;
}


void CAACEncoderDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	m_nFileRendererRecordState = 0x00000000;	

	Sleep( 100 );
	
	m_btnStart.EnableWindow( TRUE );

	m_btnStop.EnableWindow( FALSE );	

	if ( m_pTxtFile != NULL )
	{
		m_pTxtFile->Close();

		delete m_pTxtFile;

		m_pTxtFile = NULL;
	}

	if ( m_pBinFile != NULL )
	{
		m_pBinFile->Close();

		delete m_pBinFile;

		m_pBinFile = NULL;
	}
}
